%------------------------------------------------------------------------------
% File     : ALG273^5 : TPTP v7.4.0. Bugfixed v5.3.0.
% Domain   : General Algebra
% Problem  : TPS problem EQUIV-02-03
% Version  : Especial.
% English  :

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_0549 [Bro09]
%          : EQUIV-02-03 [TPS]

% Status   : Theorem
% Rating   : 0.29 v7.4.0, 0.33 v7.3.0, 0.44 v7.2.0, 0.38 v7.1.0, 0.62 v7.0.0, 0.57 v6.4.0, 0.67 v6.3.0, 0.60 v6.2.0, 0.57 v6.1.0, 0.71 v6.0.0, 0.43 v5.5.0, 0.50 v5.4.0, 0.80 v5.3.0
% Syntax   : Number of formulae    :   16 (   0 unit;   8 type;   7 defn)
%            Number of atoms       :   67 (  12 equality;  40 variable)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :   35 (   0   ~;   0   |;   4   &;  30   @)
%                                         (   1 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   43 (  43   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   10 (   8   :;   0   =)
%            Number of variables   :   24 (   0 sgn;   9   !;   2   ?;  13   ^)
%                                         (  24   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
% Bugfixes : v5.2.0 - Added missing type declarations.
%          : v5.3.0 - Fixed tType to $tType from last bugfixes.
%------------------------------------------------------------------------------
thf(g_type,type,(
    g: $tType )).

thf(cGROUP2_type,type,(
    cGROUP2: ( g > g > g ) > g > $o )).

thf(cGROUP3_type,type,(
    cGROUP3: ( g > g > g ) > g > $o )).

thf(cGRP_ASSOC_type,type,(
    cGRP_ASSOC: ( g > g > g ) > $o )).

thf(cGRP_LEFT_INVERSE_type,type,(
    cGRP_LEFT_INVERSE: ( g > g > g ) > g > $o )).

thf(cGRP_LEFT_UNIT_type,type,(
    cGRP_LEFT_UNIT: ( g > g > g ) > g > $o )).

thf(cGRP_RIGHT_INVERSE_type,type,(
    cGRP_RIGHT_INVERSE: ( g > g > g ) > g > $o )).

thf(cGRP_RIGHT_UNIT_type,type,(
    cGRP_RIGHT_UNIT: ( g > g > g ) > g > $o )).

thf(cGRP_ASSOC_def,definition,
    ( cGRP_ASSOC
    = ( ^ [Xf: g > g > g] :
        ! [Xa: g,Xb: g,Xc: g] :
          ( ( Xf @ ( Xf @ Xa @ Xb ) @ Xc )
          = ( Xf @ Xa @ ( Xf @ Xb @ Xc ) ) ) ) )).

thf(cGRP_LEFT_INVERSE_def,definition,
    ( cGRP_LEFT_INVERSE
    = ( ^ [Xf: g > g > g,Xe: g] :
        ! [Xa: g] :
        ? [Xb: g] :
          ( ( Xf @ Xb @ Xa )
          = Xe ) ) )).

thf(cGRP_LEFT_UNIT_def,definition,
    ( cGRP_LEFT_UNIT
    = ( ^ [Xf: g > g > g,Xe: g] :
        ! [Xa: g] :
          ( ( Xf @ Xe @ Xa )
          = Xa ) ) )).

thf(cGRP_RIGHT_INVERSE_def,definition,
    ( cGRP_RIGHT_INVERSE
    = ( ^ [Xf: g > g > g,Xe: g] :
        ! [Xa: g] :
        ? [Xb: g] :
          ( ( Xf @ Xa @ Xb )
          = Xe ) ) )).

thf(cGRP_RIGHT_UNIT_def,definition,
    ( cGRP_RIGHT_UNIT
    = ( ^ [Xf: g > g > g,Xe: g] :
        ! [Xa: g] :
          ( ( Xf @ Xa @ Xe )
          = Xa ) ) )).

thf(cGROUP2_def,definition,
    ( cGROUP2
    = ( ^ [Xf: g > g > g,Xe: g] :
          ( ( cGRP_ASSOC @ Xf )
          & ( cGRP_LEFT_UNIT @ Xf @ Xe )
          & ( cGRP_LEFT_INVERSE @ Xf @ Xe ) ) ) )).

thf(cGROUP3_def,definition,
    ( cGROUP3
    = ( ^ [Xf: g > g > g,Xe: g] :
          ( ( cGRP_ASSOC @ Xf )
          & ( cGRP_RIGHT_UNIT @ Xf @ Xe )
          & ( cGRP_RIGHT_INVERSE @ Xf @ Xe ) ) ) )).

thf(cEQUIV_02_03,conjecture,(
    ! [Xf: g > g > g,Xe: g] :
      ( ( cGROUP2 @ Xf @ Xe )
    <=> ( cGROUP3 @ Xf @ Xe ) ) )).

%------------------------------------------------------------------------------
